/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.atrac3;

import java.util.Arrays;
import jpcsp.Memory;
import jpcsp.media.codec.ICodec;
import jpcsp.media.codec.atrac3.Atrac3Data;
import jpcsp.media.codec.atrac3.ChannelUnit;
import jpcsp.media.codec.atrac3.Context;
import jpcsp.media.codec.atrac3.GainBlock;
import jpcsp.media.codec.atrac3.TonalComponent;
import jpcsp.media.codec.atrac3plus.Atrac;
import jpcsp.media.codec.util.BitReader;
import jpcsp.media.codec.util.CodecUtils;
import jpcsp.media.codec.util.FFT;
import jpcsp.media.codec.util.FloatDSP;
import jpcsp.media.codec.util.VLC;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class Atrac3Decoder
implements ICodec {
    public static Logger log = Logger.getLogger((String)"atrac3");
    public static final int AT3_ERROR = -2;
    public static final int JOINT_STEREO = 18;
    public static final int STEREO = 2;
    public static final int SAMPLES_PER_FRAME = 1024;
    private static final int MDCT_SIZE = 512;
    private static final float[] mdct_window = new float[512];
    private static final VLC[] spectral_coeff_tab = new VLC[7];
    private Context ctx;
    private BitReader br;
    private static boolean staticInitDone = false;

    private static void initStaticData() {
        if (staticInitDone) {
            return;
        }
        Atrac3Decoder.initImdctWindow();
        Atrac.generateTables();
        for (int i = 0; i < 7; ++i) {
            Atrac3Decoder.spectral_coeff_tab[i] = new VLC();
            spectral_coeff_tab[i].initVLCSparse(9, Atrac3Data.huff_tab_sizes[i], Atrac3Data.huff_bits[i], Atrac3Data.huff_codes[i], null);
        }
        staticInitDone = true;
    }

    @Override
    public int init(int blockAlign, int channels, int outputChannels, int codingMode) {
        int i;
        Atrac3Decoder.initStaticData();
        this.ctx = new Context();
        this.ctx.channels = channels;
        this.ctx.outputChannels = outputChannels;
        this.ctx.codingMode = codingMode != 0 ? 18 : 2;
        this.ctx.blockAlign = blockAlign;
        this.ctx.mdctCtx = new FFT();
        int ret = this.ctx.mdctCtx.mdctInit(9, true, 3.0517578125E-5);
        if (ret < 0) {
            return ret;
        }
        this.ctx.weightingDelay[0] = 0;
        this.ctx.weightingDelay[1] = 7;
        this.ctx.weightingDelay[2] = 0;
        this.ctx.weightingDelay[3] = 7;
        this.ctx.weightingDelay[4] = 0;
        this.ctx.weightingDelay[5] = 7;
        for (i = 0; i < 4; ++i) {
            this.ctx.matrixCoeffIndexPrev[i] = 3;
            this.ctx.matrixCoeffIndexNow[i] = 3;
            this.ctx.matrixCoeffIndexNext[i] = 3;
        }
        this.ctx.gaincCtx = new Atrac();
        this.ctx.gaincCtx.initGainCompensation(4, 3);
        for (i = 0; i < this.ctx.units.length; ++i) {
            this.ctx.units[i] = new ChannelUnit();
        }
        return 0;
    }

    private void imlt(float[] input, int inputOffset, float[] output, int outputOffset, boolean oddBand) {
        if (oddBand) {
            for (int i = 0; i < 128; ++i) {
                float tmp = input[inputOffset + i];
                input[inputOffset + i] = input[inputOffset + 255 - i];
                input[inputOffset + 255 - i] = tmp;
            }
        }
        this.ctx.mdctCtx.imdctCalc(output, outputOffset, input, inputOffset);
        FloatDSP.vectorFmul(output, outputOffset, output, outputOffset, mdct_window, 0, 512);
    }

    private static void initImdctWindow() {
        int i = 0;
        int j = 255;
        while (i < 128) {
            float wi = (float)Math.sin((((double)i + 0.5) / 256.0 - 0.5) * Math.PI) + 1.0f;
            float wj = (float)Math.sin((((double)j + 0.5) / 256.0 - 0.5) * Math.PI) + 1.0f;
            float w = 0.5f * (wi * wi + wj * wj);
            Atrac3Decoder.mdct_window[i] = wi / w;
            Atrac3Decoder.mdct_window[j] = wj / w;
            Atrac3Decoder.mdct_window[511 - i] = wi / w;
            Atrac3Decoder.mdct_window[511 - j] = wj / w;
            ++i;
            --j;
        }
    }

    private int decodeGainControl(GainBlock block, int numBands) {
        int b;
        for (b = 0; b <= numBands; ++b) {
            block.gBlock[b].numPoints = this.br.read(3);
            int[] level = block.gBlock[b].levCode;
            int[] loc = block.gBlock[b].locCode;
            for (int j = 0; j < block.gBlock[b].numPoints; ++j) {
                level[j] = this.br.read(4);
                loc[j] = this.br.read(5);
                if (j <= 0 || loc[j] > loc[j - 1]) continue;
                return -2;
            }
        }
        while (b < 4) {
            block.gBlock[b].numPoints = 0;
            ++b;
        }
        return 0;
    }

    private int decodeTonalComponents(TonalComponent[] components, int numBands) {
        int[] bandFlags = new int[4];
        int[] mantissa = new int[8];
        int componentCount = 0;
        int nbComponents = this.br.read(5);
        if (nbComponents == 0) {
            return 0;
        }
        int codingModeSelector = this.br.read(2);
        if (codingModeSelector == 2) {
            return -2;
        }
        int codingMode = codingModeSelector & 1;
        for (int i = 0; i < nbComponents; ++i) {
            for (int b = 0; b <= numBands; ++b) {
                bandFlags[b] = this.br.read1();
            }
            int codedValuesPerComponent = this.br.read(3);
            int quantStepIndex = this.br.read(3);
            if (quantStepIndex <= 1) {
                return -2;
            }
            if (codingModeSelector == 3) {
                codingMode = this.br.read1();
            }
            for (int b = 0; b < (numBands + 1) * 4; ++b) {
                if (bandFlags[b >> 2] == 0) continue;
                int codedComponents = this.br.read(3);
                for (int c = 0; c < codedComponents; ++c) {
                    if (componentCount >= 64) {
                        return -2;
                    }
                    TonalComponent cmp = components[componentCount];
                    int sfIndex = this.br.read(6);
                    cmp.pos = b * 64 + this.br.read(6);
                    int maxCodedValues = 1024 - cmp.pos;
                    int codedValues = codedValuesPerComponent + 1;
                    codedValues = Math.min(maxCodedValues, codedValues);
                    float scaleFactor = Atrac.ff_atrac_sf_table[sfIndex] * Atrac3Data.inv_max_quant[quantStepIndex];
                    this.readQuantSpectralCoeffs(quantStepIndex, codingMode, mantissa, codedValues);
                    cmp.numCoefs = codedValues;
                    for (int m = 0; m < codedValues; ++m) {
                        cmp.coef[m] = (float)mantissa[m] * scaleFactor;
                    }
                    ++componentCount;
                }
            }
        }
        return componentCount;
    }

    private void readQuantSpectralCoeffs(int selector, int codingFlag, int[] mantissas, int numCodes) {
        if (selector == 1) {
            numCodes /= 2;
        }
        if (codingFlag != 0) {
            int numBits = Atrac3Data.clc_length_tab[selector];
            if (selector > 1) {
                for (int i = 0; i < numCodes; ++i) {
                    int code;
                    mantissas[i] = code = numBits != 0 ? Utilities.signExtend(this.br.read(numBits), numBits) : 0;
                }
            } else {
                for (int i = 0; i < numCodes; ++i) {
                    int code = numBits != 0 ? this.br.read(numBits) : 0;
                    mantissas[i * 2] = Atrac3Data.mantissa_clc_tab[code >> 2];
                    mantissas[i * 2 + 1] = Atrac3Data.mantissa_clc_tab[code & 3];
                }
            }
        } else if (selector != 1) {
            for (int i = 0; i < numCodes; ++i) {
                int huffSymb = spectral_coeff_tab[selector - 1].getVLC2(this.br, 3);
                int code = ++huffSymb >> 1;
                if ((huffSymb & 1) != 0) {
                    code = -code;
                }
                mantissas[i] = code;
            }
        } else {
            for (int i = 0; i < numCodes; ++i) {
                int huffSymb = spectral_coeff_tab[selector - 1].getVLC2(this.br, 3);
                mantissas[i * 2] = Atrac3Data.mantissa_vlc_tab[huffSymb * 2];
                mantissas[i * 2 + 1] = Atrac3Data.mantissa_vlc_tab[huffSymb * 2 + 1];
            }
        }
    }

    private int decodeSpectrum(float[] output) {
        int i;
        int[] subbandVlcIndex = new int[32];
        int[] sfIndex = new int[32];
        int[] mantissas = new int[128];
        int numSubbands = this.br.read(5);
        int codingMode = this.br.read(1);
        for (i = 0; i <= numSubbands; ++i) {
            subbandVlcIndex[i] = this.br.read(3);
        }
        for (i = 0; i <= numSubbands; ++i) {
            if (subbandVlcIndex[i] == 0) continue;
            sfIndex[i] = this.br.read(6);
        }
        for (i = 0; i <= numSubbands; ++i) {
            int first = Atrac3Data.subband_tab[i];
            int last = Atrac3Data.subband_tab[i + 1];
            int subbandSize = last - first;
            if (subbandVlcIndex[i] != 0) {
                this.readQuantSpectralCoeffs(subbandVlcIndex[i], codingMode, mantissas, subbandSize);
                float scaleFactor = Atrac.ff_atrac_sf_table[sfIndex[i]] * Atrac3Data.inv_max_quant[subbandVlcIndex[i]];
                int j = 0;
                while (first < last) {
                    output[first] = (float)mantissas[j] * scaleFactor;
                    ++first;
                    ++j;
                }
                continue;
            }
            Arrays.fill(output, first, first + subbandSize, 0.0f);
        }
        Arrays.fill(output, Atrac3Data.subband_tab[i], 1024, 0.0f);
        return numSubbands;
    }

    private int addTonalComponents(float[] spectrum, int numComponents, TonalComponent[] components) {
        int lastPos = -1;
        for (int i = 0; i < numComponents; ++i) {
            lastPos = Math.max(components[i].pos + components[i].numCoefs, lastPos);
            for (int j = 0; j < components[i].numCoefs; ++j) {
                int n = components[i].pos + j;
                spectrum[n] = spectrum[n] + components[i].coef[j];
            }
        }
        return lastPos;
    }

    private void reverseMatrixing(float[] su1, float[] su2, int[] prevCode, int[] currCode) {
        int i = 0;
        int band = 0;
        while (band < 1024) {
            int nsample;
            int s1 = prevCode[i];
            int s2 = currCode[i];
            if (s1 != s2) {
                float mc1l = Atrac3Data.matrix_coeffs[s1 * 2];
                float mc1r = Atrac3Data.matrix_coeffs[s1 * 2 + 1];
                float mc2l = Atrac3Data.matrix_coeffs[s2 * 2];
                float mc2r = Atrac3Data.matrix_coeffs[s2 * 2 + 1];
                for (nsample = band; nsample < band + 8; ++nsample) {
                    float c1 = su1[nsample];
                    float c2 = su2[nsample];
                    su1[nsample] = c2 = c1 * this.INTERPOLATE(mc1l, mc2l, nsample - band) + c2 * this.INTERPOLATE(mc1r, mc2r, nsample - band);
                    su2[nsample] = c1 * 2.0f - c2;
                }
            }
            switch (s2) {
                case 0: {
                    float c2;
                    float c1;
                    while (nsample < band + 256) {
                        c1 = su1[nsample];
                        c2 = su2[nsample];
                        su1[nsample] = c2 * 2.0f;
                        su2[nsample] = (c1 - c2) * 2.0f;
                        ++nsample;
                    }
                    break;
                }
                case 1: {
                    float c2;
                    float c1;
                    while (nsample < band + 256) {
                        c1 = su1[nsample];
                        c2 = su2[nsample];
                        su1[nsample] = (c1 + c2) * 2.0f;
                        su2[nsample] = c2 * -2.0f;
                        ++nsample;
                    }
                    break;
                }
                case 2: 
                case 3: {
                    float c2;
                    float c1;
                    while (nsample < band + 256) {
                        c1 = su1[nsample];
                        c2 = su2[nsample];
                        su1[nsample] = c1 + c2;
                        su2[nsample] = c1 - c2;
                        ++nsample;
                    }
                    break;
                }
                default: {
                    log.fatal((Object)String.format("Invalid s2 code %d", s2));
                }
            }
            band += 256;
            ++i;
        }
    }

    private void getChannelWeights(int index, int flag, float[] ch) {
        if (index == 7) {
            ch[0] = 1.0f;
            ch[1] = 1.0f;
        } else {
            ch[0] = (float)(index & 7) / 7.0f;
            ch[1] = (float)Math.sqrt(2.0f - ch[0] * ch[0]);
            if (flag != 0) {
                float tmp = ch[0];
                ch[0] = ch[1];
                ch[1] = tmp;
            }
        }
    }

    private float INTERPOLATE(float oldValue, float newValue, int nsample) {
        return oldValue + (float)nsample * 0.125f * (newValue - oldValue);
    }

    private void channelWeighting(float[] su1, float[] su2, int[] p3) {
        float[][] w = new float[2][2];
        if (p3[1] != 7 || p3[3] != 7) {
            this.getChannelWeights(p3[1], p3[0], w[0]);
            this.getChannelWeights(p3[3], p3[2], w[1]);
            for (int band = 256; band < 1024; band += 256) {
                int nsample;
                for (nsample = band; nsample < band + 8; ++nsample) {
                    int n = nsample;
                    su1[n] = su1[n] * this.INTERPOLATE(w[0][0], w[0][1], nsample - band);
                    int n2 = nsample;
                    su2[n2] = su2[n2] * this.INTERPOLATE(w[1][0], w[1][1], nsample - band);
                }
                while (nsample < band + 256) {
                    int n = nsample;
                    su1[n] = su1[n] * w[1][0];
                    int n3 = nsample++;
                    su2[n3] = su2[n3] * w[1][1];
                }
            }
        }
    }

    private int decodeChannelSoundUnit(ChannelUnit snd, float[] output, int channelNum, int codingMode) {
        GainBlock gain1 = snd.gainBlock[snd.gcBlkSwitch];
        GainBlock gain2 = snd.gainBlock[1 - snd.gcBlkSwitch];
        if (codingMode == 18 && channelNum == 1) {
            if (this.br.read(2) != 3) {
                log.error((Object)String.format("JS mono Sound Unit id != 3", new Object[0]));
                return -2;
            }
        } else if (this.br.read(6) != 40) {
            log.error((Object)String.format("Sound Unit id != 0x28", new Object[0]));
            return -2;
        }
        snd.bandsCoded = this.br.read(2);
        int ret = this.decodeGainControl(gain2, snd.bandsCoded);
        if (ret != 0) {
            return ret;
        }
        snd.numComponents = this.decodeTonalComponents(snd.components, snd.bandsCoded);
        if (snd.numComponents < 0) {
            return snd.numComponents;
        }
        int numSubbands = this.decodeSpectrum(snd.spectrum);
        int lastTonal = this.addTonalComponents(snd.spectrum, snd.numComponents, snd.components);
        int numBands = Atrac3Data.subband_tab[numSubbands] - 1 >> 8;
        if (lastTonal >= 0) {
            numBands = Math.max(lastTonal + 256 >> 8, numBands);
        }
        for (int band = 0; band < 4; ++band) {
            if (band <= numBands) {
                this.imlt(snd.spectrum, band * 256, snd.imdctBuf, 0, (band & 1) != 0);
            } else {
                Arrays.fill(snd.imdctBuf, 0, 512, 0.0f);
            }
            this.ctx.gaincCtx.gainCompensation(snd.imdctBuf, 0, snd.prevFrame, band * 256, gain1.gBlock[band], gain2.gBlock[band], 256, output, band * 256);
        }
        snd.gcBlkSwitch ^= 1;
        return 0;
    }

    private int decodeFrame() {
        int i;
        int ret;
        if (this.ctx.codingMode == 18) {
            ret = this.decodeChannelSoundUnit(this.ctx.units[0], this.ctx.samples[0], 0, 18);
            if (ret != 0) {
                return ret;
            }
            this.br.seek(this.ctx.blockAlign - 1);
            this.br.setDirection(-1);
            while (this.br.peek(8) == 248) {
                this.br.read(8);
            }
            System.arraycopy(this.ctx.weightingDelay, 2, this.ctx.weightingDelay, 0, 4);
            this.ctx.weightingDelay[4] = this.br.read1();
            this.ctx.weightingDelay[5] = this.br.read(3);
            for (i = 0; i < 4; ++i) {
                this.ctx.matrixCoeffIndexPrev[i] = this.ctx.matrixCoeffIndexNow[i];
                this.ctx.matrixCoeffIndexNow[i] = this.ctx.matrixCoeffIndexNext[i];
                this.ctx.matrixCoeffIndexNext[i] = this.br.read(2);
            }
            ret = this.decodeChannelSoundUnit(this.ctx.units[1], this.ctx.samples[1], 1, 18);
            this.br.setDirection(1);
            this.br.seek(this.ctx.blockAlign);
            if (ret != 0) {
                return ret;
            }
            this.reverseMatrixing(this.ctx.samples[0], this.ctx.samples[1], this.ctx.matrixCoeffIndexPrev, this.ctx.matrixCoeffIndexNow);
            this.channelWeighting(this.ctx.samples[0], this.ctx.samples[1], this.ctx.weightingDelay);
        } else {
            for (i = 0; i < this.ctx.channels; ++i) {
                this.br.seek(i * this.ctx.blockAlign / this.ctx.channels);
                ret = this.decodeChannelSoundUnit(this.ctx.units[i], this.ctx.samples[i], i, this.ctx.codingMode);
                if (ret == 0) continue;
                return ret;
            }
        }
        for (i = 0; i < this.ctx.channels; ++i) {
            Atrac.iqmf(this.ctx.samples[i], 0, this.ctx.samples[i], 256, 256, this.ctx.samples[i], 0, this.ctx.units[i].delayBuf1, this.ctx.tempBuf);
            Atrac.iqmf(this.ctx.samples[i], 768, this.ctx.samples[i], 512, 256, this.ctx.samples[i], 512, this.ctx.units[i].delayBuf2, this.ctx.tempBuf);
            Atrac.iqmf(this.ctx.samples[i], 0, this.ctx.samples[i], 512, 512, this.ctx.samples[i], 0, this.ctx.units[i].delayBuf3, this.ctx.tempBuf);
        }
        return 0;
    }

    @Override
    public int decode(Memory inputMemory, int inputAddr, int inputLength, Memory outputMemory, int outputAddr) {
        this.ctx.br = this.br = new BitReader(inputMemory, inputAddr, inputLength);
        int ret = this.decodeFrame();
        if (ret < 0) {
            return ret;
        }
        CodecUtils.writeOutput(this.ctx.samples, outputMemory, outputAddr, 1024, this.ctx.channels, this.ctx.outputChannels);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Bytes read 0x%X", this.ctx.br.getBytesRead()));
        }
        return this.ctx.br.getBytesRead();
    }

    @Override
    public int getNumberOfSamples() {
        return 1024;
    }
}

